function [fitresult, gof] = Create_Surface_Fit(X, Y, Z)
%CREATESURFACEFIT(X,Y,Z)
%  Fit surface to data.
%
%  Input Data:
%      X Input : X
%      Y Input : Y
%      Z output: Z
%      Weights : (none)
%
%  Output:
%      fitresult : an sfit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, SFIT.
global opts;
global ft;

%% Create Surface Fit

% first, create function string
flux = ['((1/2) * ((luxR_tot + (K_A_2__K_LuxR / (4 * (u1^2)))) - ' ...
        ' sqrt((luxR_tot + (K_A_2__K_LuxR / (4 * (u1^2))))^2 - (luxR_tot^2))))'];

fci  = '((u2 / 2) + (1 / (8 * K_D_CI)) * (1 - sqrt(1 + 8 * K_D_CI * u2)))';
        
fnc  = ['(c0 + c1 * ' flux ') / (1 + c0 + c1 * ' flux ' + c2 * (' fci '^n) + c1 * c2 * ' flux ' * (' fci '^n))'];  
ft = fittype(fnc, 'indep', {'u1', 'u2'}, 'depend', 'z' );

%
% Fit Params:
% K_A_2__K_LuxR,K_D_CI,c0,c1,c2,luxR_tot,n,u1,u2
%
opts = fitoptions( ft );
opts.Display = 'iter';  % originally 'off'
opts.Lower = [0 0 -Inf -Inf -Inf 0 1.0];

% initial starting points for paramater values (from paper)
K_A_2__K_LuxR = 270000;  % nM^3
K_D_CI = 5;  % nM
c0 = 0.04;
c1 = 0.05;
c2 = 0.11;
luxR_tot = 2000; % nM
n = 1.5; 
opts.StartPoint = [K_A_2__K_LuxR K_D_CI c0 c1 c2 luxR_tot n];

opts.Upper = [Inf Inf Inf Inf Inf Inf Inf];
%opts.Lower = [1 0.1 0.01 0.01 0.01 1 0.1];
%opts.StartPoint = [270000 5 0.04 0.05 0.11 2000 1.5];
%opts.Upper = [999999 99 9 9 9 99999 99];
opts.Weights = zeros(1,0);
opts.Robust = 'On';
opts.TolFun = 1e-15;
opts.TolX   = 1e-30;

[fitresult, gof] = fit( [X, Y], Z, ft, opts );

% Plot fit with data.
figure( 'Name', 'Plux_CI surface function fit' );
h = plot( fitresult, [X, Y], Z );
grid on
% Label axes
xlabel( 'AHL' );
ylabel( 'CI' );
zlabel( 'betagal' );
legend( h, 'Plux_CI', 'betgal vs. AHL, CI', 'Location', 'NorthEast' );
